#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <mpi.h>

int main(int argc, char *argv[]) {
    int rank, size;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    int P = atoi(argv[1]);

    /* verificare corectitudine */
    if (size != P) {
        MPI_Finalize();
        return 0;
    }

    /* procesele 1..P-1 execută sleep */
    if (rank != 0) {
        int sleep_time = atoi(argv[rank + 1]);
        sleep(sleep_time);

        /* notifică procesul 0 */
        MPI_Send(&rank, 1, MPI_INT, 0, 0, MPI_COMM_WORLD);
    }
    /* procesul 0 afișează mesajele */
    else {
        for (int i = 0; i < P - 1; i++) {
            int finished_rank;
            MPI_Recv(&finished_rank, 1, MPI_INT,
                     MPI_ANY_SOURCE, 0, MPI_COMM_WORLD, MPI_STATUS_IGNORE);

            printf("Thread-ul %d a terminat\n", finished_rank);
            fflush(stdout);
        }
    }

    MPI_Finalize();
    return 0;
}
